# 【NO.32】谈谈 C/C++ 和 JAVA 哪个更有前景！

## 1.**概述**

在学校或者已经踏入职场的朋友们，相信很多朋友们都会被这个问题所困扰，到底是选C++还是选JAVA？C++和JAVA哪个更有前途呢？作为一个学习计算机编程的人士来说，回头看，发现任何编程语言都是优美的。C，C++，JAVA从流行的程度来看，基本并驾齐驱，无论从从一年的排名，都基本处于前TOP5，至于说那个发展前景好，这个是仁者见仁，智者见智。可以说存在即符合逻辑。我们换个角度来看问题吧。

![img](https://pic4.zhimg.com/80/v2-af58d69165d3c408bc076529204e9997_720w.webp)

## 2.**C++编程语言的应用与发展**

从事嵌入式开发十几年了，从入行开始就使用C/C++写代码，现在市场整体感觉已经不如当初那么火爆了，编程语言现在向着两个大趋势发展。其一高度集成化，利用现成的类库实现一个基本功能只需要很短的代码就够了，充分挖掘这些年编程行业积累的经验和成功；其二对于一些性能要求比较高的行业，C/C++依然占据着非常大的空间，但相比第一种已经有明显的差距，像现在人工智能出现推动了python的发展，但在一些关键的算法模块，底层实现还是要依靠C/C++这种性能非常强的编程语言。

![img](https://pic1.zhimg.com/80/v2-735dcb83bf18d7172bc73446c68b094c_720w.webp)

### 2.1**C/C++的应用主要有以下几方面**

- 服务器端开发

很多游戏或者互联网公司的后台服务器程序都是基于C++开发的，而且大部分是linux操作系统，所以说，你如果想做这样的工作，需要熟悉linux操作系统及其在上面的开发，熟悉数据库开发，精通网络编程。

- 游戏开发

市面上相当多的游戏引擎都是基于C++开发的，比如Cocos2d、虚幻4等，这些游戏引擎的代表作有失落的方舟、绝地求生、地狱之刃、中国象棋、雷电传说、俄罗斯方块、保卫萝卜、捕鱼达人、开心消消乐等等。

- 虚拟现实

虚拟现实（VR）是一种可以创建和体验虚拟世界的计算机仿真系统，是利用计算机生成的一种实时动态的三维立体逼真图像，结合VR眼镜，可以在观影、游戏、旅游活动、教学等方面给人一种完美的沉浸体验。C++在这一技术中同样扮演着重要的角色。

- 数字图像处理

比如OpenCV视觉识别技术。

- 网络软件

C++拥有大量成熟的用于网络通信的库，ACE是其中最具有代表性的跨平台库，在许多重要的企业部门甚至是军方都有应用。

- 科学计算

在科学计算领域，FORTRAN是使用最多的语言之一。但是C++凭借先进的数值计算库、泛型编程等优势在这一领域也应用颇多。

- 操作系统

操作系统主要使用的编程语言是C，但是C++凭借其对C的兼容性，面向对象性质也开始在该领域有一席之地。等。

## 3.**JAVA编程语言的应用与发展**

如今，社会正处于互联网快速发展的阶段，不仅是Java程序，而且所有程序员都有很大的差距，尤其是优秀的程序。Java程序应用广泛，可以作为后台服务。它可以作为一个前端页面。安卓开发也是基于Java语言，Java作为一种跨平台语言在某些领域非常有优势。那么Java开发有哪些发展前景?

世界上并没有完美的程序，因为写程序本来就是一个不断追求完美的过程。同样没有一门语言在一诞生就是完美的，不变的唯有变化。Java诞生至今已经不仅仅是一门语言，背后所涵盖的是一个庞大的技术体系。

在过去二十年Java的发展是孤独求败的，在未来，Java也在迎接着各种挑战，这种挑战来自云原生、容器化、也来自其他设计更完善的语言，相信身怀各种绝技的Java会焕发出更加夺目的光彩，重新攀登另一个高峰。

![img](https://pic1.zhimg.com/80/v2-80ecf35e30ae1bbea24be30bb324c3ec_720w.webp)

发展至今，Java不仅是一门编程语言，还是一个由一系列计算机软件和规范组成的技术体系，Java 是几乎所有类型的网络应用程序的基础，也是开发和提供嵌入式和移动应用程序、游戏、基于 Web 的内容和企业软件的全球标准。

从笔记本电脑到数据中心，从游戏控制台到科学超级计算机，从手机到互联网，Java 无处不在！

- 97% 的企业桌面运行 Java
- 美国有 89% 的桌面（或计算机）运行 Java
- 全球有 900 万 Java 开发人员
- 开发人员的头号选择
- 排名第一的部署平台
- 有 30 亿部移动电话运行 Java
- 100% 的蓝光盘播放器附带了 Java
- 有 50 亿张 Java 卡在使用
- 1.25 亿台 TV 设备运行 Java
- 前 5 个原始设备制造商均提供了 Java ME

![img](https://pic4.zhimg.com/80/v2-f142635769a3b21ce8c46ae13f313a7f_720w.webp)

## 4.**综合分析Java开发的最初目的是Web，C++则主要是针对应用软件：**

- C++ 比较面向底层，速度快，而且windows开发非常友好。以后出来做桌面然见，游戏开发，嵌入式 C C++都使用。目前绝大数的大型的网络游戏都是C++开发的，3D游戏则更不用说了。但C++的学习曲线远远陡于JAVA，想擅长精通C++不是简单的事。
- 在系统编程和驱动编程中，更多的使用C/C++，与硬件打交道，C/C++充分利用硬件优势发挥其高效的性能，这方面JAVA就不行了，JAVA还有性能上的先天缺陷（不过现在很多好的JAVA解释器的优化策略非常好，不过就牺牲了可移植性）。
- 如果以后出来想走J2EE，Android App 或者 J2ME等方向，可以学JAVA。JAVA在网络编程中比C++更具有先天的优势，这主要考虑到了JAVA的高可移植性和易开发性。
- JAVA培训现在都模式工厂化了，然而C++从深度上是远超JAVA的。JAVA太过于依赖XML，C++是高风险高灵活高效率，JAVA主要是稳定，仅仅入门的话C++更简单。JAVA能做的C++都能做，C++能做的，JAVA不一定能做。如果一个人精通各种编程语言的话，显然C++给他的发挥空间更大。

总之，不管是学JAVA还是学C++，语言不是核心，但要有一两门非常精通，这样才有市场竞争力。

**至于薪资，术业有专攻，也不能说C++工程师工资就肯定比JAVA高。**

- 精通C/C++ 转换到其他语言是件很轻松的事情。
- 程序是种工具，软件为行业服务，行业的经验也很重要。再者程序员的工资决定于项目的收益，语言在其次。

## 5.最后，分享一个c/c++后端开发的学习知识图谱（摘自零声教育的大纲）

**c++后端开发是一个庞杂的技术栈，因为没有统一的开发框架并且应用行业非常广泛。所有涉猎广泛，这里就把c/c++后端开发的技术点进行整理总结，看完以后，不会让你失望的。**

1. 精进基石
2. 高性能网络设计
3. 基础组建设计
4. 中间件开发
5. 开源框架
6. 性能分析
7. 分布式架构
8. 上线实战



**1、精进基石，分为四个方面（数据结构，设计模式，c++新特性，Linux工程管理）**

数据结构部分

![img](https://pic4.zhimg.com/80/v2-a5e872e3f4ebff5f2e47f2839381a697_720w.webp)

设计模式

![img](https://pic3.zhimg.com/80/v2-03372ea2ce2feba7b108b66afeeb6e86_720w.webp)

C++新特性

![img](https://pic4.zhimg.com/80/v2-e50b7ad8735d347813040f9f90659aff_720w.webp)

linux工程管理

![img](https://pic4.zhimg.com/80/v2-176af3c57e8866f90356046dac8cc39f_720w.webp)

**2. 高性能网络设计（网络编程，网络原理，协程ntyco，用户态协议栈ntytcp）**

网络编程

![img](https://pic4.zhimg.com/80/v2-5426286b52a4957bc46d48b4b9768563_720w.webp)

网络原理

![img](https://pic3.zhimg.com/80/v2-30bacbf284fb94be950b8e3596d8d0aa_720w.webp)

自研框架： 纯c实现的协程（2000行代码）

![img](https://pic3.zhimg.com/80/v2-b6c40b94153b578adcb44fe354126bda_720w.webp)

自研tcp协议栈

![img](https://pic3.zhimg.com/80/v2-55103cd32fabf773893fe9e4ab525bd6_720w.webp)

高性能异步io机制io_uring

![img](https://pic2.zhimg.com/80/v2-b340e0b3ad0f7ceaab837839532e4f11_720w.webp)



**3. 基础组建设计，分为3部分， 池式组件，高性能组件，开源组件**

池式结构

![img](https://pic4.zhimg.com/80/v2-72e17934511f04b79d01387dd94b86af_720w.webp)

高性能组件

![img](https://pic1.zhimg.com/80/v2-21b403e920c42f632a0dee44c271c858_720w.webp)

开源组件

![img](https://pic4.zhimg.com/80/v2-449701cb30c276c67d2623835aa9c6bf_720w.webp)

4、中间件开发专栏

redis

![img](https://pic2.zhimg.com/80/v2-bbd008b47aaad5448750f93ceb95107d_720w.webp)

mysql

![img](https://pic2.zhimg.com/80/v2-411af5395fd23586dadb09a155430a45_720w.webp)

kafka

![img](https://pic3.zhimg.com/80/v2-fd1a3b402cdadbc1c9cfc56aa51f5ce6_720w.webp)

gRPC

![img](https://pic1.zhimg.com/80/v2-a2cea85a67a10a5e8563cf7cd0caef04_720w.webp)

nginx

![img](https://pic4.zhimg.com/80/v2-e8f9b4ca68300f7c797012869cfdfe2f_720w.webp)

**5. 开源框架**

游戏后端开源框架 skynet

![img](https://pic3.zhimg.com/80/v2-ef9162678cafae13eefb9bd94f85c53a_720w.webp)

分布式API网关

![img](https://pic1.zhimg.com/80/v2-70a66668b090577855763d4dbcac07a0_720w.webp)

DPDK

![img](https://pic1.zhimg.com/80/v2-16aa9606a881b6caf0b5765d571adfb0_720w.webp)

高性能计算CUDA

![img](https://pic2.zhimg.com/80/v2-19977aff14842f4756a6cb5d505f6f91_720w.webp)

**6、云原生专栏**

**docker**

![img](https://pic3.zhimg.com/80/v2-94e4caa56462fa1e22e31c92eb8137de_720w.webp)

kubernetes

![img](https://pic2.zhimg.com/80/v2-4f5ab6da7b798ebdde603942cab39481_720w.webp)

**7、性能分析专栏**

**性能与测试工具**

![img](https://pic3.zhimg.com/80/v2-021a78849d8efbf9e55e58e9581f4c6e_720w.webp)

观测技术bpf与ebpf

![img](https://pic3.zhimg.com/80/v2-16af55bef7b272f54e2a52f9f2983fda_720w.webp)

内核源码机制

![img](https://pic3.zhimg.com/80/v2-d7d1469ca1fc6e4bcf75247f47ab0842_720w.webp)



**8、分布式架构专栏**

**rocksdb**

![img](https://pic3.zhimg.com/80/v2-e6ce9f016c9bdf3aa775e593b43199fa_720w.webp)

TiDB

![img](https://pic4.zhimg.com/80/v2-cc8fddf5551aaa0b4aa5155ea529be5b_720w.webp)

分布式服务

![img](https://pic3.zhimg.com/80/v2-f22f724500b4f8e7b4d63bed73f92392_720w.webp)

**9、上线项目实战（可以写入简历的两个实战项目，让面试不再为没有项目发愁）**

**1、图床共享云存储**

**2、微服务即时通讯**

原文地址：https://zhuanlan.zhihu.com/p/590865083  

原文作者：linux